


// Referenced classes of package duggelz.jape:
//            Field

class StringField
    implements Field
{

    public StringField(int offset, int length)
    {
        this.offset = offset;
        this.length = length;
    }

    public String get(byte data[])
    {
        StringBuffer sb = new StringBuffer();
        for(int i = 0; i < length / 2; i++)
        {
            byte b0 = data[offset + i * 2];
            byte b1 = data[offset + i * 2 + 1];
            char c = (char)(b0 & 0xff | (b1 & 0xff) << 8);
            if(c == 0)
                break;
            sb.append(c);
        }

        return sb.toString();
    }

    public int getInt(byte data[])
        throws NumberFormatException
    {
        return Integer.parseInt(get(data));
    }

    public void set(byte data[], String value)
    {
        for(int i = 0; i < length / 2; i++)
        {
            char c = '\0';
            if(i < value.length())
                c = value.charAt(i);
            data[offset + i * 2] = (byte)(c & 0xff);
            data[offset + i * 2 + 1] = (byte)((c & 0xff) >>> 8);
        }

    }

    public void setInt(byte data[], int value)
    {
        set(data, Integer.toString(value));
    }

    private int offset;
    private int length;
}